
//>>>>>>>>>>>>>>>>>>>>>>>>
//cgi-datalogger.c
//>>>>>>>>>>
//This file contains the CGI responder function for the Datalogger / Sampler configuration page.
//


#include <mqx.h>
#include <httpd.h>
#include <main.h>
#include <cgi.h>
#include <string.h>

#include <ltctwrutils.h>
#include <ltctwrboard.h>

#include <logging.h>

extern uint_32 samplerprogresscount;

extern HTTPSRV_CGI_RES_STRUCT response;
extern char     buffer[100];
extern uint_32  ptr;

//CGI Function that configures the DataLogger Task with the appropriate parameters

_mqx_int cgi_adcdatalogger_set(HTTPSRV_CGI_REQ_STRUCT *param) {
	uint_32  len = 0;
	char     span[2], setting[2], temp[2], interval[10], numsamp[10], logname[16];
	
	char     channame1859[3] = "A0";
	char     channame2498[3] = "B0";
        uint_8  i;
        HTTPSRV_CGI_RES_STRUCT response;
    
	
	boolean  bParams = FALSE; 
	char buffer[100];
	//uint_32  result;
	
	uint_8 spanindex, setindex, count;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
	
	pointer pt;
        _task_id id;
	

	//Get pointer and configure
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();

	

	//If we got a response of non-zero length
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents (except channel) are present
		if (cgi_get_varval( buffer, "int", interval, sizeof(interval)) &&
			cgi_get_varval( buffer, "num", numsamp, sizeof(numsamp)) &&
			cgi_get_varval( buffer, "destname", logname, sizeof(logname)) &&
			cgi_get_varval( buffer, "span", span, sizeof(span)) &&
			cgi_get_varval( buffer, "setting", setting, sizeof(setting))) {
			
			bParams =  TRUE;
			
			sprintf(LTCTWR_Params_Ptr->destname,"c:/%s.csv", logname);
			printf("Destination Filename: %s\n", LTCTWR_Params_Ptr->destname);
			
			//Are we also sourcing data?
			if(cgi_get_varval( buffer, "read", temp, sizeof(temp))) 
            {
            	//If yes, where from?
            	cgi_get_varval( buffer, "srcname", logname, sizeof(logname));
            	sprintf(LTCTWR_Params_Ptr->srcname,"c:/%s.csv", logname);
		printf("Source Filename: %s\n", LTCTWR_Params_Ptr->srcname);
            }
            else
            {
            	LTCTWR_Params_Ptr->srcname[0] = 0;
            }
			
			
			LTCTWR_Params_Ptr->numsamples = str2int(numsamp);
			printf("Number of Samples: %d\n", LTCTWR_Params_Ptr->numsamples);
			LTCTWR_Params_Ptr->samplingperiod = str2int(interval);
			printf("Sampling Period: %d\n", LTCTWR_Params_Ptr->samplingperiod);
			
            spanindex = (*(char*)span) - mask;//Figure out the Span (1859)
            printf("1859 Span Index: %d\n", spanindex);
	    LTCTWR_Params_Ptr->span1859 = LTC1859SpanSelect[spanindex];

            
            setindex = (*(char*)setting) - mask;//Figure out the Setting (2498)
            printf("2498 Setting Index: %d\n", setindex);
            LTCTWR_Params_Ptr->setting2498 = LTC2498SettingSelect[setindex];
            
            
            //Find the selected channels
            count = 0;
            for (i = 0; i<16; i++) 
            {
            	channame1859[1] = (char)(i + 0x41);
            	if(cgi_get_varval( buffer, channame1859, temp, sizeof(temp))) 
	            {
	            	printf("%s selected\n", channame1859);
	            	LTCTWR_Params_Ptr->channels1859[count] = LTC1859ChannelSelect[i];
	            	count ++;
	            }
            }
            LTCTWR_Params_Ptr->numchannels1859 = count;
			
			
			count = 0;
            for (i = 0; i<16; i++) 
            {
            	channame2498[1] = (char)(i + 0x41);
            	if(cgi_get_varval( buffer, channame2498, temp, sizeof(temp))) 
	            {
	            	printf("%s selected\n", channame2498);
	            	LTCTWR_Params_Ptr->channels2498[count] = LTC2498LoggerChannelSelect[i];
	            	count ++;
	            }
            }
            LTCTWR_Params_Ptr->numchannels2498 = count;
            
     
    response.ses_handle = param->ses_handle;
    response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
    response.status_code = 200;

			response.data =	"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=adclogger.html\"></HEAD>"
			"<BODY></BODY></HTML>";   
			
  			//_task_create(0, 5, 0);  //5 is the logger task
			//LTC1859_LogCurrentState(); 
    response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
        	
       		printf("Setup complete, unblocking sampler\n");
	  		id = _task_get_id_from_name("Sampler");  //Only good way to get the id
	 		pt = _task_get_td(id);
	 		_task_ready(pt);
    				
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
    response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
}


_mqx_int cgi_sampler_progress(HTTPSRV_CGI_REQ_STRUCT *param) {
	
        char buffer[20];
        LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
        HTTPSRV_CGI_RES_STRUCT response;
        uint_32 length = 0;
        
        response.ses_handle = param->ses_handle;
        response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
        response.status_code = 200;
        LTCTWR_Params_Ptr = LTCTWR_GetParameters();
        length = snprintf(buffer, 20, "%d\n%d\n%d\n", 
                          samplerprogresscount, 
                          samplerprogresscount, 
                          samplerprogresscount);
        
        response.data = buffer;
        response.data_length = length;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response); 
	return response.content_length;
        
}

